//////////
//
//	File:		WinFramework.h
//
//	Contains:	Basic functions for windows, menus, and similar things.
//
//	Written by:	Tim Monroe
//				Based on MDIPlayer sample code by Brian S. Friedkin (Aug 5, 1996).
//
//	Copyright:	 1996-1998 by Apple Computer, Inc., all rights reserved.
//
//	Change History (most recent first):
//
//	   <2>	 	11/02/98	rtm		minor reworking to coordinate with MacFramework.h
//	   <1>	 	07/03/96	rtm		first file; revised to personal coding style;
//									renamed numerous types and parameters to mirror QTShell on MacOS
//	   
//////////

#pragma once

// header files

#ifndef __Prefix_File__
#include <WinPrefix.h>
#endif

#ifndef __FIXMATH__
#include <FixMath.h>
#endif

#ifndef __MOVIES__
#include <Movies.h>
#endif

#ifndef __RESOURCES__
#include <Resources.h>
#endif

#ifndef __QTML__
#include <QTML.h>
#endif

#ifndef __QUICKTIMEVR__
#include <QuickTimeVR.h>
#endif

#ifndef __SCRAP__
#include <Scrap.h>
#endif

#ifndef __SOUND__
#include <Sound.h>
#endif

#ifndef __TEXTUTILS__
#include <TextUtils.h>
#endif

#ifndef __QTUtilities__
#include "QTUtilities.h"
#endif

#include <windows.h>


//////////
//
// constants
//
//////////

#define	WM_PUMPMOVIE				(WM_USER+0)
#define	WM_OPENDROPPEDFILES			(WM_USER+1)
#define USEEXPLORERSTYLE			(LOBYTE(LOWORD(GetVersion()))>=4)
#define kOpenDialogCustomData		11						// an arbitrary value that allows our dialog proc to detect the Open File dialog box
#define kAlertMessageMaxLength		256						// maximum length of a message in the DoCautionAlert message box

#define kNewMovieName				"C:\\untitled.mov"		// default name of a movie created by "New" menu command

#define kInvalidFileRefNum			-1						// an invalid file reference number

#define kWinFilePathSeparator		(char)'\\'				// on Windows, the file path separator is '\\'

// items in Save Changes dialog box
#define kSaveChanges				IDYES					// save the changes before closing window
#define kCancelClose				IDCANCEL				// no, don't close the window or save changes
#define kDontSaveChanges			IDNO					// discard any unsaved changes

// constants for standard modal dialog filter proc
#define kMyButtonDelay				8
#define kReturnKey					(char)0x0D	
#define kEnterKey					(char)0x03	
#define kEscapeKey					(char)0x1B	
#define kPeriod						'.'

// constants for selecting InitApplication phase
enum {
	kInitAppPhase_BeforeCreateFrameWindow 	= 1L << 0,		// MDI frame window windows not yet created
	kInitAppPhase_AfterCreateFrameWindow	= 1L << 1,		// MDI frame window windows already created
	kInitAppPhase_BothPhases				= kInitAppPhase_BeforeCreateFrameWindow | kInitAppPhase_AfterCreateFrameWindow
};

// constants for selecting StopApplication phase
enum {
	kStopAppPhase_BeforeDestroyWindows 		= 1 << 0,		// movie windows not yet torn down
	kStopAppPhase_AfterDestroyWindows		= 1	<< 1,		// movie windows already torn down
	kStopAppPhase_BothPhases				= kStopAppPhase_BeforeDestroyWindows | kStopAppPhase_AfterDestroyWindows
};

// parameters to the SetMenuItemState function
#define kEnableMenuItem				MF_ENABLED
#define kDisableMenuItem			MF_GRAYED

enum {
	kMovieControllerObject  		= FOUR_CHAR_CODE('MCvr')
};


//////////
//
// macros
//
//////////

// macros for converting Mac menu ID/menu item pairs into a single "menu item identifier"
#define MENU_IDENTIFIER(menuID,menuItem)	((menuID<<8)+(menuItem))
#define MENU_ID(menuIdentifier)				((menuIdentifier&0xff00)>>8)
#define MENU_ITEM(menuIdentifier)			((menuIdentifier&0x00ff))


//////////
//
// data types
//
//////////

typedef HMENU				MenuReference;
typedef HWND				WindowReference;


//////////
//
// structures
//
//////////

// WindowObjectRecord is a data structure attached to a movie window.
// We use this structure to associate data with any window presented.

typedef struct {
	WindowReference			fWindow;			// the window
	OSType					fObjectType;		// specific tag indicating that the window object belongs to our application
	Movie					fMovie;				// the main movie (QT or QTVR)
	MovieController 		fController;		// the movie controller for this window
	FSSpec					fFileFSSpec;		// location of the movie file
	short					fFileResID;
	short					fFileRefNum;
	Boolean					fCanResizeWindow;	// can the window be resized?
	Boolean					fDirty;				// has the movie data changed since the last save?
	QTVRInstance			fInstance;			// the QTVRInstance
	Handle					fAppData;			// a handle to application-specific window data
} WindowObjectRecord, *WindowObjectPtr, **WindowObject;


//////////
//
// function prototypes
//	   
//////////

LRESULT CALLBACK 			FrameWndProc (HWND theWnd, UINT theMessage, UINT wParam, LONG lParam);
LRESULT CALLBACK 			MovieWndProc (HWND theWnd, UINT theMessage, UINT wParam, LONG lParam);
BOOL						GetFile (char *theFileName);
int							AdjustMenus (HWND theWnd, HMENU theMenu);
void						QuitFramework (void);

Boolean 					DoCreateNewMovie (void);
MovieController				SetupMovieWindowWithController (Movie theMovie, WindowReference theWindow, Boolean theMoveWindow);
void						DoOpenCommandLineMovies (LPSTR theCmdLine);
BOOL						DoCreateMovieWindow (Movie theMovie, FSSpec *theFSSpec);
void						DoSaveAsMovieWindow (WindowReference theWindow);
Boolean						DoUpdateMovieFile (WindowReference theWindow);
static void					DoCut (HWND theWnd);
static void					DoCopy (HWND theWnd);
static void					DoPaste (HWND theWnd);
static void					DoClear (HWND theWnd);
static void					DoUndo (HWND theWnd);
static void					GetDisplayName (char *thePathName, char *theFileName);

void						SizeWindowToMovie (WindowObject theWindowObject);
static void					ShowAboutBox (void);
int							DoCautionAlert (HWND theWnd, UINT theID, UINT theIconStyle, UINT theButtonStyle, LPSTR theTitle, LPSTR theArgument);
static UINT APIENTRY		DialogProc (HWND theDialog, UINT theMessage, WPARAM wParam, LPARAM lParam);
static void					CalcWindowMinMaxInfo (HWND theWnd, LPMINMAXINFO lpMinMax);
static void					SetWindowTitleFromFSSpec (HWND theWnd, FSSpec *theFSSpec, Boolean theAddToRecentDocs);

WindowReference				GetFrontMovieWindow (void);
WindowReference				GetNextMovieWindow (WindowReference theWindow);
WindowObject				GetWindowObjectFromFrontWindow (void);
WindowObject				GetWindowObjectFromWindow (WindowReference theWnd);
MovieController  			GetMCFromFrontWindow (void);
MovieController				GetMCFromWindow (WindowReference theWindow);
QTVRInstance				GetQTVRInstanceFromFrontWindow (void);
Handle						GetAppDataFromFrontWindow (void);
Handle						GetAppDataFromWindow (WindowReference theWnd);
Handle						GetAppDataFromWindowObject (WindowObject theWindowObject);
Boolean 					IsWindowObjectOurs (WindowObject theWindowObject);
void						DoBeep (void);
void						SetMenuState (MenuReference theMenu, UInt16 theMenuRank, short theState);
void						SetMenuItemState (MenuReference theMenu, UInt16 theMenuItem, short theState);
void						SetMenuItemLabel (MenuReference theMenu, UInt16 theMenuItem, char *theText);
void						SetMenuItemCheck (MenuReference theMenu, UInt16 theMenuItem, Boolean theState);
GrafPtr						GetPortFromWindowReference (WindowReference theWindow);
WindowReference				GetWindowReferenceFromPort (GrafPtr thePort);
short						GetWindowWidth (WindowReference theWindow);


// application-specific functions
// These are defined in the ComApplication.c file;
// you could override these to change the behavior of the function in a specific application.
void						InitApplication (UInt32 theStartPhase);
void						StopApplication (UInt32 theStopPhase);
void						DoIdle (WindowReference theWindow);
void						DoUpdateWindow (WindowReference theWindow, Rect *theRefrehArea);
void 						HandleContentClick (WindowReference theWindow, EventRecord *theEvent);
Boolean						HandleApplicationKeyPress (char theCharCode);
void 						HandleApplicationMenu (UInt16 theMenuItem);
void						AdjustApplicationMenus (WindowReference theWindow, MenuReference theMenu);
Boolean						DoApplicationEventLoopAction (EventRecord *theEvent);
void						AddControllerFunctionality (MovieController theMC);
void						InitApplicationWindowObject (WindowObject theWindowObject);
void						RemoveApplicationWindowObject (WindowObject theWindowObject);
PASCAL_RTN Boolean 			ApplicationMCActionFilterProc (MovieController theMC, short theAction, void *theParams, long theRefCon);